#pragma once

#include "ThreadBase.h"
#include "DataType.h"
//typedef bool (CALLBACK *MsgFunc)(OP_Result result, ITP_OPERATION operation, char *data, int len, void *userData);
class CSilkModuleDlg;
class CUserModule : public CThreadBase
{
public:
	CUserModule(IMsgListener *pListener, CThreadBase *pThread);
	virtual ~CUserModule();
	void HeartBeat_Imp();
	void DealOneRequestMsg(CInterProtocl *pITP);
	void DealOneResponseMsg(CInterProtocl *pITP);
public:
	IMsgListener *m_pListener;
	CThreadBase *m_pThread;
	IResultListener *m_pResListerner;

	bool connect(int connectType);
	bool disConnect();
	bool enroll(int pin, int flag);
	bool enrollByImage(char *image, int len, int pin);
	void startReadData();
	void stopReadData();

	bool addUser(TUser &user);
	bool readUser(int pin, TUser &user);
	bool loadUser();
	bool deleteUser(int pin = 0);

	bool deleteTmp(int pin = 0);
	bool deleteDB();
	
	bool verifyFp(int pin);
	bool verifyFp(char *image, int len);

	bool scanFpImage();
	bool testProtocol();

	bool setTime(int year, int month, int day, int hour, int min, int sec);
	bool getTime(int &year, int &month, int &day, int &hour, int &min, int &sec);
	bool readParam();
	bool writeParam(SetParam &param);
	bool saveParam();
	
	bool enrollTmp(int pin, char *tmp, int len);
	bool loadTmp();
	bool readTmp(int pin);
	bool delLog();
	bool loadLog();
	bool updata(char *data, int len);
	bool reset();
	bool scanTmp();

	//bool setCallback(MsgFunc cbFunc, void *param);
	bool setResultListerner(IResultListener *pListerner);
private:
	void SetResult(CInterProtocl *pITP);
	void writeBitmap(char *imgout,  char *buffer, int nWidth, int nHeight);
	bool WaitResult();
private:
	HANDLE m_hEvent;
	int m_timelast;
	int m_year;
	int m_month;
	int m_day;
	int m_hour;
	int m_min;
	int m_sec;
	char m_tmp[640*420];
	int m_tmpLen1;
	int m_tmpLen2;
	int m_tmpLen3;
	int m_result;

	//MsgFunc m_cbMsgFunc;
	//void *m_pUserData;
};